/*
 * Copyright (c) 2024 FabulaTech.
 * All rights reserved.
 * Permission to use this software as a part of FabulaTech solution only is
 * granted.
 * http://www.fabulatech.com
 */

#ifndef __FTDEFS_H_
#define __FTDEFS_H_

#include <linux/version.h>
#include <linux/usb.h>
#include <hcd.h>

#include "fthclink.h"

extern int verbose;
#define logdk(...) \
	do { if (verbose) { printk(KERN_DEBUG __VA_ARGS__); } } while(0)

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,26)
#define FTHC_HS_MAX_PORTS		USB_MAXCHILDREN
#else
#define FTHC_HS_MAX_PORTS		(USB_MAXCHILDREN - 1)
#endif
#ifdef USB_DT_SS_HUB
#ifndef USB_SS_MAXPORTS
#define USB_SS_MAXPORTS		7
#endif
#define FTHC_SS_MAX_PORTS	USB_SS_MAXPORTS
#else
#define FTHC_SS_MAX_PORTS	0
#endif
#define FTHC_MAX_PORTS		(FTHC_HS_MAX_PORTS + FTHC_SS_MAX_PORTS)


/* Private data attached to the hcd */
struct hcdpriv {
	struct usb_hcd *hcd_hs;
	struct usb_hcd *hcd_ss;
	spinlock_t lock;
	int pending_port;
	struct {
		u32 status;
		u32 speed;
		int pending;
		int suspended;
		struct usb_device *usbdev;
		unsigned long re_timeout;
	} ports[FTHC_MAX_PORTS];
	struct list_head urbs;
};
extern struct hcdpriv *hcd_instance;

/* Host controller driver instance */
extern const struct hc_driver fthc_driver;

/* Urb manipulation */
struct urb;
struct urbpriv;

/* Urb manipulation */
void urbpriv_list_init(void);
struct urbpriv *urbpriv_alloc(gfp_t mem_flags);
void urbpriv_init(struct urbpriv *urbpriv, struct urb *urb,
    unsigned int func, int port);
int urbpriv_lock(struct urbpriv *urbpriv);
void urbpriv_unlock(struct urbpriv *urbpriv);
struct urb *urbpriv_urb(struct urbpriv *urbpriv);
unsigned int urbpriv_func(struct urbpriv *urbpriv);
unsigned int urbpriv_seq(struct urbpriv *urbpriv);
unsigned int urbpriv_pipe(struct urbpriv *urbpriv);
int urbpriv_port(struct urbpriv *urbpriv);
void urbpriv_set_func(struct urbpriv *urbpriv, unsigned int func);
void urbpriv_unlink(struct urbpriv *urbpriv);
void urbpriv_unref(struct urbpriv *urbpriv);
void urbpriv_unlock_unref(struct urbpriv *urbpriv);
struct urbpriv *urb_to_urbpriv(struct urb *urb);
struct urbpriv *urbpriv_get_pending_urb(void);
struct urbpriv *urbpriv_get_submitted_urb_reverse(void);
struct urbpriv *urbpriv_by_seq(unsigned long seq);
void urbpriv_set_submitted(struct urbpriv *urbpriv);
void urbpriv_set_pending(struct urbpriv *urbpriv);
void urbpriv_unset_submitted(struct urbpriv *urbpriv);
void urbpriv_unset_pending(struct urbpriv *urbpriv);
int urbpriv_has_pending_urbs(void);
int urbpriv_pending(struct urbpriv *urbpriv);

int fthc_refcnt_inc(void);
void fthc_refcnt_dec(void);
int fthc_port_enable(hcd_port_t *port);
void fthc_port_disable(hcd_port_t *port);

int link_create(void);
void link_destroy(void);
int link_urb_dequeue(struct urb *urb);
void link_urb_enqueue(struct urb *urb, struct urbpriv *urbpriv, int port);
void link_urb_special(struct urbpriv *urbpriv, unsigned int func, int port);

#endif /* __FTDEFS_H_ */
