/*
 * Copyright (c) 2024 FabulaTech.
 * All rights reserved.
 * Permission to use this software as a part of FabulaTech solution only is
 * granted.
 * http://www.fabulatech.com
 */

#ifndef __FTHCLINK_H_
#define __FTHCLINK_H_

#ifdef __KERNEL__
#define LINK_DEVICE_NAME "ftlink"
#else
#define LINK_DEVICE_NAME "/dev/ftlink"
#endif

#ifndef __KERNEL__
#define PIPE_ISOCHRONOUS		0
#define PIPE_INTERRUPT			1
#define PIPE_CONTROL			2
#define PIPE_BULK			3

/* Urb pipe information */
#define USB_DIR_IN			0x80
#define usb_pipein(pipe)	((pipe) & USB_DIR_IN)
#define usb_pipeout(pipe)	(!usb_pipein(pipe))

#define usb_pipedevice(pipe)	(((pipe) >> 8) & 0x7f)
#define usb_pipeendpoint(pipe)	(((pipe) >> 15) & 0xf)

#define usb_pipetype(pipe)	(((pipe) >> 30) & 3)
#define usb_pipeisoc(pipe)	(usb_pipetype((pipe)) == PIPE_ISOCHRONOUS)
#define usb_pipeint(pipe)	(usb_pipetype((pipe)) == PIPE_INTERRUPT)
#define usb_pipecontrol(pipe)	(usb_pipetype((pipe)) == PIPE_CONTROL)
#define usb_pipebulk(pipe)	(usb_pipetype((pipe)) == PIPE_BULK)

/* Urb flags */
#define URB_SHORT_NOT_OK	0x0001	/* Report short reads as errors */
#define URB_ZERO_PACKET		0x0040	/* Finish bulk OUT with short packet */
#endif

#define FTHC_GROUP 'h'

/* Host Controller port speed */
#define FTHC_SPEED_LOW		1
#define FTHC_SPEED_FULL		2
#define FTHC_SPEED_HIGH		3
#define FTHC_SPEED_SUPER	4

/**
 * Host Controller port descriptor
 */
typedef struct __attribute__((packed)) {
	int32_t port_number;
	uint32_t speed;
} hcd_port_t;

/**
 * Host Controller internal URB packet
 */
#define FUNC_URB	0
#define FUNC_RESET	1
#define FUNC_CANCEL	2
#define FUNC_SUSPEND	3
#define FUNC_RESUME	4
typedef struct __attribute__((packed)) {
	uint32_t size;
	uint32_t seq;
	uint32_t func;
	int32_t port;
	uint32_t pipe;
	uint32_t flags;
	int32_t status;
	uint32_t length;
	uint32_t numiso;
	uint8_t buffer[0];
} urb_t;

typedef struct __attribute__((packed)) {
	uint32_t offset;
	uint32_t length;
	int32_t status;
} iso_frame_t;

typedef struct __attribute__((packed)) {
	hcd_port_t port;
	int32_t busnum;
	int32_t devnum;
} hcd_dev_addr_t;

#define IOCTL_PORT_ENABLE	_IOWR(FTHC_GROUP, 0, hcd_port_t)
#define IOCTL_PORT_DISABLE	_IOR(FTHC_GROUP, 1, hcd_port_t)
#define IOCTL_GET_URB_HDR	_IOW(FTHC_GROUP, 2, urb_t)
#define IOCTL_GET_URB_BUF	_IOWR(FTHC_GROUP, 3, urb_t *)
#define IOCTL_COMPLETE_URB	_IOR(FTHC_GROUP, 4, urb_t *)
#define IOCTL_GET_HCD_DEV_ADDR	_IOWR(FTHC_GROUP, 5, hcd_dev_addr_t)

#endif /* __FTHCLINK_H_ */
