#include "rdesktop.h"
#include "ftusbrdp.h"

#include <fcntl.h>
#include <sys/stat.h>
#include <unistd.h>
#include <netinet/in.h>

static VCHANNEL *ftusbw, *ftusbr;


int ftusb_pkt_state;

struct ftusb_packet hdr;
char *ftusb_pkt_buf;
size_t ftusb_pkt_len;

static void
ftusbw_process(STREAM s)
{
	size_t pkglen;
	char *buf;

	pkglen = s->end - s->p;
	buf = (char *) xmalloc(pkglen);

	memcpy(buf, s->p, pkglen);
	warning("This channel is write-only!\n");

	xfree(buf);
}

int ftusb_id2fd(uint32_t id)
{
	struct ftusb_conn *conn;
	LIST_FOREACH(conn, &ftusb_connlist, entries) {
		if (conn->id == id)
			return conn->fd;
	}
	return -1;
}

void
ftusb_close_conn(int id)
{
	int fd;
	struct ftusb_conn *conn;

	ftusb_dbg("Close connection %x", id);

	fd = ftusb_id2fd(id);
	ftusb_dbg("fd = 0x%x", fd);

	close(fd);

	LIST_FOREACH(conn, &ftusb_connlist, entries) {
		if (conn->id == id) {
			LIST_REMOVE(conn, entries);
			xfree(conn);
		}
	}
}

static void
ftusb_rdp_process_pkt(struct ftusb_packet *hdr)
{
	int fd;
	struct sockaddr_in sa;
	struct ftusb_conn *conn;

	switch (hdr->command) {
		case 0x00:
			ftusb_dbg("Create connection %x", hdr->id);
			conn = xmalloc(sizeof(struct ftusb_conn));
			conn->id = hdr->id;
			conn->fd = socket(PF_INET, SOCK_STREAM, 0);

			sa.sin_family = AF_INET;
			sa.sin_port = htons(33000); //XXX define it
			sa.sin_addr.s_addr = INADDR_ANY;

			ftusb_dbg("fd = 0x%x\n", conn->fd);

			connect(conn->fd, (struct sockaddr *) &sa, sizeof(struct sockaddr));
			LIST_INSERT_HEAD(&ftusb_connlist, conn, entries);
			break;

		case 0x01:
			ftusb_close_conn(hdr->id);
			break;

		case 0x02:
			ftusb_dbg("Data to 0x%x, %d bytes", hdr->id, hdr->datasize);

			fd = ftusb_id2fd(hdr->id);
			ftusb_dbg("fd = 0x%x", fd);

//			hexdump((uint8_t *)(hdr+1), hdr->datasize);
			write(fd, (char *)(hdr+1), hdr->datasize);
			break;

		default:
			error("Invalid command: %d", hdr->command);
			sleep(1);
	}
}

static void
ftusbr_process(STREAM s)
{
	size_t pkglen;
	struct ftusb_packet *hdr;

	ftusb_dbg("got data from channel:\n");
	pkglen = s->end - s->p;
	hdr = (struct ftusb_packet *) xmalloc(pkglen);

	memset(hdr, 0xfe, pkglen);

	memcpy(((char *)hdr), (char *) s->p, pkglen);

//	hexdump((unsigned char *)hdr, pkglen);

	ftusb_rdp_process_pkt(hdr);

	xfree(hdr);
}

void ftusb_socket_process(int fd, int id)
{
	int n_read;
	char buf[200];
	STREAM s;
	struct ftusb_packet hdr;

	n_read = read(fd, buf, sizeof(buf));
	if (n_read <= 0) {
		ftusb_dbg("Clsoe conn: %x/%x\n", fd, id);
		ftusb_close_conn(id);
		return;
	}
//	hexdump((uint8_t *)buf, n_read);

	hdr.command = 0x02;
	hdr.id = id;
	hdr.datasize = n_read;

	s = channel_init(ftusbw, n_read + sizeof(struct ftusb_packet));
	out_uint8p(s, &hdr, sizeof(struct ftusb_packet));
	out_uint8p(s, buf, n_read);
	s_mark_end(s);

	channel_send(s, ftusbw);
}

void ftusb_check_fds(fd_set *rfds, fd_set *wfds)
{
	struct ftusb_conn *conn;
	LIST_FOREACH(conn, &ftusb_connlist, entries) {
		if (FD_ISSET(conn->fd, rfds))
			ftusb_socket_process(conn->fd, conn->id);
	}
}

void ftusb_add_fds(int *n, fd_set * rfds, fd_set * wfds, struct timeval *tv)
{
	struct ftusb_conn *conn;
	LIST_FOREACH(conn, &ftusb_connlist, entries) {
//		printf("fd: %p ", conn->fd);
		FD_SET(conn->fd, rfds);
		if (conn->fd > *n)
			*n = conn->fd;		
	}
//	printf("\n");
}

RD_BOOL ftusbrdp_init(void)
{
	ftusb_dbg("Initialization...\n");

	ftusbw = channel_register("FTUSBW", CHANNEL_OPTION_INITIALIZED,
					ftusbw_process);
	ftusbr = channel_register("FTUSBR", CHANNEL_OPTION_INITIALIZED,
					ftusbr_process);

	if ((ftusbw == NULL) || (ftusbr == NULL))
	{
		error("channel_register\n");
		return False;
	}
	
	LIST_INIT(&ftusb_connlist);

	return True;
}
