#!/bin/sh
# This script integrates FabuleTech component to NICE DCV
#

set -e

FT_EXT_FILE="ftdcvbr.json"
FT_EXT_DIR="/opt/ftplugins/share"
EXT_DIR="/usr/share/dcvextensions"
WPS_CONF_FILE="/etc/wsp/wsp.conf"

usage () {
echo "\
Usage: $(basename $0) -i|-u,
where:
        -i      - Install NICE DCV support
        -u      - Uninstall NICE DCV support
        -h      - Show help"
}

enable_extension() {
if [ -f "$1" ]
then
	sed '/extensions.*=/s/.*/extensions = "enabled"/' "$1" > "$1".tmp
	cat "$1".tmp > "$1"
	rm -f "$1".tmp
fi
}

disable_extension() {
if [ -f "$1" ]
then
	sed '/extensions.*=/s/.*/#extensions = "disabled"/' "$1" > "$1".tmp
	cat "$1".tmp > "$1"
	rm -f "$1".tmp
fi
}

inst() {
	if [ ! -d  $EXT_DIR  ]
	then
		mkdir $EXT_DIR
		if [ $? != 0 ]
		then
			echo "ERROR: failed to cteate directory: $EXT_DIR"
		fi
	fi
	
	cp -f $FT_EXT_DIR/$FT_EXT_FILE $EXT_DIR
	if [ $? != 0 ]; then
		echo "ERROR: failed to copy: $FT_EXT_DIR/$FT_EXT_FILE"
		exit 1
	fi
	echo "Installed successfully"
}

uninst() {
	rm $EXT_DIR/$FT_EXT_FILE
	
	if [ $? = 0 ]
	then
		echo "Uninstalled successfully"
	else
		echo "WARNING: failed to remove: $EXT_DIR/$FT_EXT_FILE"
	fi
}

case "$1" in
"-i")
	inst
	enable_extension "$WPS_CONF_FILE"
	;;
"-u")
	uninst
	disable_extension "$WPS_CONF_FILE"
	;;
"-h")
	usage
	;;
*)
	usage
	;;
esac

