#!/bin/sh

#set -e

LIB_DIR="/opt/ftplugins/lib"
LIB_NAME_10="ftrdpbr.so"
LIB_NAME_11="ftrdpbr-client.so"
LIB_NAME_12="libftrdpbr-client.so"
LIB_NAMES="$LIB_NAME_10 $LIB_NAME_11 $LIB_NAME_12"

ARCH="unknown"
RDP_VERSION_MAJOR=-1
RDP_VERSION_MINOR=-1
RDP_VERSION_REVISION=-1
LINK_COUNT=0

usage () {
echo "\
Usage: $(basename $0) -i|-u,
where:
        -i      - Install FreeRDP support
        -u      - Uninstall FreeRDP support
        -h      - Show help"
}

gnu_suffixes () {
	p1="gnu"
	p2="gnueabi"
	p3="gnueabihf"
	echo $p1 $p2 $p3
}

rdp1_dirs () {
	p1="/usr/lib/freerdp"
	p2="/usr/local/lib/freerdp"
	p3="/usr/lib64/freerdp"
	p4="/usr/local/lib64/freerdp"
	echo $p1 $p2 $p3 $p4

	if [ "x$ARCH" != "xunknown" ]
	then
		suffixes=$(gnu_suffixes)
		for suf in $suffixes
		do
			p1="/usr/lib/$ARCH-linux-$suf/freerdp"
			p2="/usr/local/lib/$ARCH-linux-$suf/freerdp"
			p3="/usr/lib64/$ARCH-linux-$suf/freerdp"
			p4="/usr/local/lib64/$ARCH-linux-$suf/freerdp"
			echo $p1 $p2 $p3 $p4
		done
	fi
}

rdp2_dirs () {
	dirs=$(rdp1_dirs)
	for dir in $dirs
	do
		echo "$dir"2
	done
}

get_arch () {
	if [ "x$(uname -m | grep 'x86_64')" != "x" ]
	then
		ARCH="x86_64"
		return
	fi
	if [ "x$(uname -m | grep 'i686')" != "x" ]
	then
		ARCH="i386"
		return
	fi
	if [ "x$(uname -m | grep 'arm')" != "x" ]
	then
		ARCH="arm"
		return
	fi
	if [ "x$(uname -m | grep 'mips')" != "x" ]
	then
		ARCH="mips"
		return
	fi
}

get_rdp_version () {
	prefix="This is FreeRDP version "
	pattern="[0-9][0-9]*.[0-9][0-9]*.[0-9][0-9]*"
	version=`xfreerdp --version`
	version=$(echo "$version" | grep -o "$prefix$pattern" | grep  -o "$pattern")
	if [ "x$version" = "x" ]
	then
		return
	fi
	version=$(echo $version | grep -o [0-9][0-9]*)
	for var in $version
	do
		if [ $RDP_VERSION_MAJOR -eq -1 ]
		then
			RDP_VERSION_MAJOR=$var
			continue
		fi
		if [ $RDP_VERSION_MINOR -eq -1 ]
		then
			RDP_VERSION_MINOR=$var
			continue
		fi
		if [ $RDP_VERSION_REVISION -eq -1 ]
		then
			RDP_VERSION_REVISION=$var
			continue
		fi
		RDP_VERSION_REVISION=-1
		break
	done
	if [ $RDP_VERSION_REVISION -eq -1 ]
	then
		RDP_VERSION_MAJOR=-1
		RDP_VERSION_MINOR=-1
	fi
}

unlink_plugin () {
	dir=$1
	name=$2

	path="$dir/$name"
	if [ -h $path -o -f $path ]
	then
		rm $path
		if [ $? = 0 ]
		then
			echo "removed: $path"
		else
			echo "WARNING: unable to remove: $path"
		fi
	fi
}

link_plugin () {
	dir=$1
	name=$2

	if [ -d $dir ]
	then
		path="$dir/$name"
		lib="$LIB_DIR/$name"
		ln -s $lib $path
		if [ $? = 0 ]
		then
			echo "linked: $path"
			LINK_COUNT=$(($LINK_COUNT + 1))
		else
			echo "WARNING: unable to create link: $path"
		fi
	fi
}

unlink_all () {
	dirs="$(rdp1_dirs) $(rdp2_dirs)"
	for dir in $dirs
	do
		for name in $LIB_NAMES
		do
			unlink_plugin $dir $name
		done
	done
}

link_all () {
	#for now, git version FreeRDP (git 9d4811e) doesn't create directory for plugins
	if [ $RDP_VERSION_MAJOR -eq 2 ]
	then
		if [ "x$ARCH" != "xunknown" ]
		then
			dirs="/usr/lib /usr/local/lib /usr/lib/$ARCH-linux-gnu /usr/local/lib/$ARCH-linux-gnu"
		else
			dirs="/usr/lib /usr/local/lib"
		fi
		for dir1 in $dirs
		do
			dir2="$dir1/freerdp2"
			if [ ! -d  $dir1  ]
			then
				mkdir $dir1
				if [ $? != 0 ]
				then
					echo "WARNING: unable to cteate directory: $dir1"
				fi
			fi
			if [ -d  $dir1 -a ! -d $dir2  ]
			then
				mkdir $dir2
				if [ $? != 0 ]
				then
					echo "WARNING: unable to cteate directory: $dir2"
				fi
			fi
		done
	fi

	case $RDP_VERSION_MAJOR in
	1)
		dirs=$(rdp1_dirs)
		for dir in $dirs
		do
			case $RDP_VERSION_MINOR in
			0)
				link_plugin $dir $LIB_NAME_10
				;;
			1)
				link_plugin $dir $LIB_NAME_11
				;;
			*)
				link_plugin $dir $LIB_NAME_12
				;;
			esac
		done
		;;
	2)
		dirs=$(rdp2_dirs)
		for dir in $dirs
		do
			link_plugin $dir $LIB_NAME_12
		done
		;;
	*)
		dirs="$(rdp1_dirs) $(rdp2_dirs)"
		for dir in $dirs
		do
			for name in $LIB_NAMES
			do
				link_plugin $dir $name
			done
		done
		;;
	esac
	
	if [ $LINK_COUNT -eq 0 ]
	then
		echo "WARNING: no links were created"
	fi
}

get_arch
if [ "x$ARCH" = "xunknown" ]
then
	echo "WARNING: unable to detect machine type"
fi

case $1 in
"-i")
	unlink_all
	get_rdp_version
	if [ $RDP_VERSION_MAJOR -eq -1 ]
	then
		echo "WARNING: unable to detect FreeRDP version"
	else
		echo "found FreeRDP version $RDP_VERSION_MAJOR.$RDP_VERSION_MINOR.$RDP_VERSION_REVISION"
	fi
	link_all
	;;
"-u")
	unlink_all
	;;
"-h")
	usage
	;;
*)
	usage
	;;
esac

