#! /bin/sh
# This script integrates FabuleTech library to Teradici Agent, Teradici Client
# and VMware Horizon Client

set -e

LIB_PATH="/opt/ftplugins/lib/ftpcoipbr.so"
CLIENT_DIR="/usr/lib/pcoip"
CLIENT_PLUGINS_DIR="/usr/lib/pcoip/vchan_plugins"
AGENT_PLUGINS_DIR="/usr/lib/pcoip-agent/vchan-plugins"
LIB_NAME="libvchan-plugin-ftpcoipbr.so"

print_msg () {
echo "$@" 1>&2
}

usage () {
print_msg "\
Usage: $(basename $0) -i|-u,
where:
        -i      - Install PCoIP support
        -u      - Uninstall PCoIP support
        -h      - Show help"
}

link_lib () {
	if [ -d "$AGENT_PLUGINS_DIR" ]
	then
		ln -s $LIB_PATH "$AGENT_PLUGINS_DIR/$LIB_NAME"
		if [ $? = 0 ]
		then
			print_msg "Installed for PCoIP Agent"
		else
			print_msg "ERROR: unable to cteate link: $AGENT_PLUGINS_DIR/$LIB_NAME"
		fi
	fi
	
	if [ ! -d  $CLIENT_DIR  ]
	then
		mkdir $CLIENT_DIR
		if [ $? != 0 ]
		then
			print_msg "ERROR: unable to cteate directory: $CLIENT_DIR"
		fi
	fi
	if [ -d  $CLIENT_DIR -a ! -d $CLIENT_PLUGINS_DIR  ]
	then
		mkdir $CLIENT_PLUGINS_DIR
		if [ $? != 0 ]
		then
			print_msg "ERROR: unable to cteate directory: $CLIENT_PLUGINS_DIR"
		fi
	fi
	if [ -d $CLIENT_PLUGINS_DIR  ]
	then
		ln -s $LIB_PATH "$CLIENT_PLUGINS_DIR/$LIB_NAME"
		if [ $? = 0 ]
		then
			print_msg "Installed for PCoIP Client"
		else
			print_msg "ERROR: unable to cteate link: $CLIENT_PLUGINS_DIR/$LIB_NAME"
		fi
	fi
}

unlink_lib () {
	rm -f "$AGENT_PLUGINS_DIR/$LIB_NAME"
	rm -f "$CLIENT_PLUGINS_DIR/$LIB_NAME"
}

case "$1" in
"-i")
	unlink_lib
	link_lib
	;;
"-u")
	unlink_lib
	;;
"-h")
	usage
	;;
*)
	usage
	;;
esac
