#! /bin/sh
# This script integrates FabuleTech library to Teradici Agent
# and VMware Horizon Client

set -e

LIB_PATH="/opt/ftplugins/lib/ftpcoipbr.so"
TERADICI_AGENT_DIR="/usr/lib/pcoip-agent/vchan-plugins"
VMWARE_CLIENT_DIR="/usr/lib/pcoip/vchan_plugins"
LIB_NAME="libvchan-plugin-ftpcoipbr.so"

TERADICI_AGENT_INSTALLED=false
VMWARE_CLIENT_INSTALLED=false

print_msg () {
echo "$@" 1>&2
}

usage () {
print_msg "\
Usage: $(basename $0) -i|-u,
where:
        -i      - Install PCoIP support
        -u      - Uninstall PCoIP support
        -h      - Show help"
}

link_lib () {
	if [ "$TERADICI_AGENT_INSTALLED" = true ]
	then
		ln -s $LIB_PATH "$TERADICI_AGENT_DIR/$LIB_NAME"
		print_msg "Installed for Teradici Agent"
	fi
	if [ "$VMWARE_CLIENT_INSTALLED" = true ]
	then
		ln -s $LIB_PATH "$VMWARE_CLIENT_DIR/$LIB_NAME"
		print_msg "Installed for VMware Horizon Client"
	fi
}

unlink_lib () {
	rm -f "$TERADICI_AGENT_DIR/$LIB_NAME"
	rm -f "$VMWARE_CLIENT_DIR/$LIB_NAME"
}

check_for_installation () {
	if [ -d "$TERADICI_AGENT_DIR" ]
	then
		TERADICI_AGENT_INSTALLED=true
	fi
	if [ -d "$VMWARE_CLIENT_DIR" ]
	then
		VMWARE_CLIENT_INSTALLED=true
	fi
	if [ "$TERADICI_AGENT_INSTALLED" = false -a "$VMWARE_CLIENT_INSTALLED" = false ]
	then
		print_msg "Directory $TERADICI_AGENT_DIR does not exists, probably Teradici Agent is not installed"
		print_msg "Directory $VMWARE_CLIENT_DIR does not exists, probably VMware Horizon Client is not installed"
		exit 1
	fi
}

case "$1" in
"-i")
	check_for_installation
	unlink_lib
	link_lib
	;;
"-u")
	unlink_lib
	;;
"-h")
	usage
	;;
*)
	usage
	;;
esac

