#!/bin/sh
# This script integrates FabuleTech component for Web Bridge
#

set -e

SYSYTEM_PATH=/etc/systemd/system
SRV_PATH=/opt/ftplugins/etc/systemd/system
SRV_NAME=ftrdpws.service

usage () {
echo "\
Usage: $(basename $0) -i|-u,
where:
        -i      - Install Web Bridge support
        -u      - Uninstall Web Bridge support
        -h      - Show help"
}

case "$1" in
"-i")
	cp $SRV_PATH/$SRV_NAME $SYSYTEM_PATH
	if [ $? != 0 ]; then
		echo "ERROR: failed to copy: $SRV_NAME"
		exit 1
	fi
	systemctl daemon-reload
	systemctl enable $SRV_NAME
	if [ $? != 0 ]; then
		echo "ERROR: failed to enable: $SRV_NAME"
		exit 1
	fi
	systemctl start $SRV_NAME
	if [ $? != 0 ]; then
		echo "ERROR: failed to start: $SRV_NAME"
		exit 1
	fi
	echo "Installed successfully"
	;;
"-u")
	systemctl disable $SRV_NAME
	if [ $? != 0 ]; then
		echo "ERROR: failed to disable: $SRV_NAME"
		exit 1
	fi
	systemctl stop $SRV_NAME
	if [ $? != 0 ]; then
		echo "ERROR: failed to stop: $SRV_NAME"
		exit 1
	fi
	echo "Uninstalled successfully"
	;;
"-h")
	usage
	;;
*)
	usage
	;;
esac
